#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This program belongs to AKKODIS INGENIERIE PRODUIT SAS.
# It is considered a trade secret, and is not to be divulged or used
# by parties who have not received written authorization from the owner.
#

# the main class
# basically a collection of values for installation
import sys,os
sys.path.append(os.path.dirname( os.path.realpath( __file__ ) ))
import infinite

class proxyInstallationInfos(infinite.commonInstallationInfos) :
	#object init
	def __init__(self) :
		infinite.commonInstallationInfos.__init__(self)

	## creates the folder hierarchy
	def createFolders (self) :
		infinite.createProxyFolders(self)

	def checkProxyInstallationSoftwares(self) :
		infinite.checkServerInstallationSoftwares(self,[])

	def configureApache(self):
		infinite.configureApache(self)
	
	def installBinary (self) :	
		if sys.platform == 'win32':
			params = {
				'Setup' : {
					'Lang' : 'en',
					'Dir' : self.proxy_binary_folder,
					}
				}
		else :
			params = {
				self.proxy_binary_installer + '/eula' : ('string', 'yes'),
			}
		infinite.installInfiniteBinary(self,self.proxy_binary_installer,self.proxy_service_name, params, [self.proxy_binary_installer])
	
	def configureBinary(self):
		infinite.configureInfiniteService(self,self.proxy_service_name,self.proxy_createdb_command)
	
	def startServices(self) :
		infinite.restartService(self.proxy_service_name)

if __name__ == '__main__':
	import sys,os,time
	
	lTimeStart = time.time();
	
	# make sure we can import the required module
	os.chdir(os.path.dirname( os.path.realpath( __file__ ) ))
	
	lInfos = proxyInstallationInfos()
	
	# read from csv or from code
	lInfos.fromYaml('./form_proxy_or_server.yaml','./validation_schema/schema_proxy_or_server.json')
	
	# check admin rights
	lInfos.checkPrerequisites()
	
	lInfos.checkProxyInstallationSoftwares()
	
	lInfos.stopInfiniteServices()
	
	# install redistributables
	lInfos.prepareSystem()
	# create folder hierarchy
	lInfos.createFolders()
	# create ssl key certificate pair
	lInfos.createSSL()
	# install postgres
	lInfos.installPostgres()
	# configure postgres
	lInfos.configurePostgres()
	# install postgres plugins
	lInfos.installPostgresPlugins()
	# install elasticsearch
	lInfos.installElasticSearch()
	# register elastic search service and the like
	lInfos.patchElasticSearch()
	# configure elasticsearch
	lInfos.configureElasticSearch()
	# install apache
	lInfos.installApache()
	# install apache plugins
	lInfos.installApachePlugins()
	# patch apache
	lInfos.patchApacheProxy()
	# configure the eseditor
	lInfos.configureEsEditor()
	# install infinite proxy
	lInfos.installBinary()
	# configure service
	lInfos.configureBinary()
	# configure apache
	lInfos.configureApache()
	# start the services
	lInfos.startServices()
	
	lTimeEnd = time.time();
	
	print("Installation done in %d s" % int(lTimeEnd - lTimeStart))
	